<!-- Modal Ubah User -->
<div class="modal fade" id="ubahJatah{{ $item->id }}" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content shadow-lg border-0">

            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title">
                    <i class="fas fa-user-edit me-2"></i> Ubah Data
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form action="{{ route('admin.jatah-cuti.update', $item->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="modal-body">

                    <div class="mb-3">
                        <label for="karyawan_id{{ $item->id }}" class="form-label">Nama Karyawan</label>
                        <select name="karyawan_id" id="karyawan_id{{ $item->id }}" class="form-select" required>
                            <option value="" disabled>Pilih karyawan....</option>
                            @foreach ($karyawan as $list)
                                <option value="{{ $list->id }}"
                                    {{ $item->karyawan_id == $list->id ? 'selected' : '' }}>
                                    {{ $list->user->nama }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Tahun</label>
                        <input type="number" name="tahun" class="form-control" value="{{ $item->tahun }}" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Jatah Cuti</label>
                        <input type="number" name="jatah" class="form-control" value="{{ $item->jatah }}" required>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Batal
                    </button>
                    <button type="submit" class="btn btn-warning">
                        Simpan Perubahan
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>
